<?php
/**
 * Admin Password Reset/Verification Script
 * Run this file once to reset admin password or verify setup
 */

require_once __DIR__ . '/bot/config.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>Admin Password Reset - SMM Bot</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; background: #f5f5f5; }
        .container { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1 { color: #333; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 12px; border-radius: 5px; margin: 10px 0; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 12px; border-radius: 5px; margin: 10px 0; }
        .info { background: #d1ecf1; border: 1px solid #bee5eb; color: #0c5460; padding: 12px; border-radius: 5px; margin: 10px 0; }
        code { background: #f4f4f4; padding: 2px 6px; border-radius: 3px; }
        .btn { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block; }
        .btn:hover { background: #0056b3; }
    </style>
</head>
<body>
    <div class='container'>
        <h1>🔐 Admin Password Reset</h1>";

try {
    // Connect to database
    $db = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    echo "<div class='success'>✅ Database connection successful</div>";
    
    // Check if admin_users table exists
    $stmt = $db->query("SHOW TABLES LIKE 'admin_users'");
    if ($stmt->rowCount() === 0) {
        echo "<div class='error'>❌ Table 'admin_users' does not exist. Please run setup.php first.</div>";
        echo "<div class='info'><a href='setup.php' class='btn'>Run Setup</a></div>";
        echo "</div></body></html>";
        exit;
    }
    
    echo "<div class='success'>✅ Table 'admin_users' exists</div>";
    
    // Check if admin user exists
    $stmt = $db->query("SELECT * FROM admin_users WHERE username = 'admin'");
    $admin = $stmt->fetch();
    
    if (!$admin) {
        echo "<div class='info'>⚠️ Admin user does not exist. Creating now...</div>";
        
        // Create admin user
        $password = 'admin123';
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $db->prepare("INSERT INTO admin_users (username, password, email) VALUES (?, ?, ?)");
        $stmt->execute(['admin', $hashed, 'admin@example.com']);
        
        echo "<div class='success'>✅ Admin user created successfully!</div>";
        echo "<div class='info'>";
        echo "<strong>Login Credentials:</strong><br>";
        echo "Username: <code>admin</code><br>";
        echo "Password: <code>admin123</code><br>";
        echo "</div>";
    } else {
        echo "<div class='success'>✅ Admin user exists</div>";
        
        // Reset password
        $password = 'admin123';
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $db->prepare("UPDATE admin_users SET password = ? WHERE username = 'admin'");
        $stmt->execute([$hashed]);
        
        echo "<div class='success'>✅ Password has been reset!</div>";
        echo "<div class='info'>";
        echo "<strong>New Login Credentials:</strong><br>";
        echo "Username: <code>admin</code><br>";
        echo "Password: <code>admin123</code><br>";
        echo "</div>";
    }
    
    // Test the password
    $stmt = $db->query("SELECT * FROM admin_users WHERE username = 'admin'");
    $admin = $stmt->fetch();
    
    if (password_verify('admin123', $admin['password'])) {
        echo "<div class='success'>✅ Password verification successful!</div>";
    } else {
        echo "<div class='error'>❌ Password verification failed!</div>";
    }
    
    echo "<div class='info' style='margin-top: 20px;'>";
    echo "<strong>Next Steps:</strong><br>";
    echo "1. <a href='admin/' class='btn'>Go to Admin Panel</a><br><br>";
    echo "2. Login with the credentials above<br>";
    echo "3. Delete this file (reset_admin.php) after successful login<br>";
    echo "</div>";
    
    echo "<div class='info' style='margin-top: 20px; background: #fff3cd; border-color: #ffc107; color: #856404;'>";
    echo "<strong>⚠️ Security Warning:</strong><br>";
    echo "Delete this file after use to prevent unauthorized password resets!";
    echo "</div>";
    
} catch(PDOException $e) {
    echo "<div class='error'>❌ Database Error: " . htmlspecialchars($e->getMessage()) . "</div>";
    echo "<div class='info'>";
    echo "<strong>Troubleshooting:</strong><br>";
    echo "1. Check database credentials in <code>bot/config.php</code><br>";
    echo "2. Ensure database exists<br>";
    echo "3. Run <a href='setup.php'>setup.php</a> first<br>";
    echo "</div>";
}

echo "</div></body></html>";
