<?php
/**
 * Telegram Bot Webhook Handler
 * 
 * This file receives updates from Telegram and routes them to appropriate handlers
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/handlers.php';

// Get incoming update
$content = file_get_contents("php://input");
$update = json_decode($content, true);

// Log for debugging (remove in production)
file_put_contents(__DIR__ . '/webhook.log', date('Y-m-d H:i:s') . " - " . $content . "\n", FILE_APPEND);

if (!$update) {
    http_response_code(200);
    exit;
}

try {
    // Handle different update types
    
    // Message (including /start command)
    if (isset($update['message'])) {
        $message = $update['message'];
        $chat_id = $message['chat']['id'];
        $telegram_id = $message['from']['id'];
        $username = $message['from']['username'] ?? '';
        $first_name = $message['from']['first_name'] ?? 'User';
        
        // Handle commands
        if (isset($message['text']) && strpos($message['text'], '/') === 0) {
            $command_parts = explode(' ', $message['text']);
            $command = $command_parts[0];
            
            if ($command === '/start') {
                // Extract start parameter (referral code)
                $start_param = null;
                if (count($command_parts) > 1) {
                    $start_param = $command_parts[1];
                }
                
                handleStart($chat_id, $telegram_id, $username, $first_name, $start_param);
            } else {
                sendMessage($chat_id, "Unknown command. Use /start to begin.");
            }
        } else {
            // Handle regular text messages
            handleMessage($message);
        }
    }
    
    // Callback query (button presses)
    if (isset($update['callback_query'])) {
        handleCallback($update['callback_query']);
    }
    
} catch (Exception $e) {
    error_log("Webhook Error: " . $e->getMessage());
}

http_response_code(200);
