<?php
/**
 * Admin Authentication Handler
 */

// Session Configuration (must be set BEFORE session_start)
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);

session_start();
require_once __DIR__ . '/../bot/config.php';
require_once __DIR__ . '/../bot/database.php';

function isAdminLoggedIn() {
    return isset($_SESSION['admin_id']) && isset($_SESSION['admin_username']);
}

function requireAdmin() {
    if (!isAdminLoggedIn()) {
        header('Location: index.php');
        exit;
    }
}

function loginAdmin($username, $password) {
    $db = Database::getInstance()->getConnection();
    
    $stmt = $db->prepare("SELECT * FROM admin_users WHERE username = ?");
    $stmt->execute([$username]);
    $admin = $stmt->fetch();
    
    if ($admin && password_verify($password, $admin['password'])) {
        $_SESSION['admin_id'] = $admin['id'];
        $_SESSION['admin_username'] = $admin['username'];
        
        // Update last login
        $stmt = $db->prepare("UPDATE admin_users SET last_login = NOW() WHERE id = ?");
        $stmt->execute([$admin['id']]);
        
        return true;
    }
    
    return false;
}

function logoutAdmin() {
    session_destroy();
    header('Location: index.php');
    exit;
}

// Handle logout
if (isset($_GET['logout'])) {
    logoutAdmin();
}
