# 🤖 Telegram SMM Bot with Admin Panel

A complete Telegram bot system with PHP backend that functions as an SMM (Social Media Marketing) panel. Users can earn points through referrals and use them to order social media services.

## ✨ Features

### User Features
- 🎁 **100 points** starting bonus for new users
- 👥 **Referral system** - Earn 100 points per referral
- 📱 **Multiple services**:
  - Instagram Views
  - Telegram Views
  - Telegram Members
  - Telegram Reactions
- 💎 **Points-based ordering** - Minimum 400 points per order
- 📊 **Order tracking** - View order history and status
- 🔗 **Unique referral links** for each user

### Admin Features
- 📊 **Dashboard** with statistics
- 📦 **Order management** - Approve/reject orders
- 👥 **User management** - View and edit user points
- ⚙️ **Service configuration** - Edit pricing and availability
- 🔔 **Automatic notifications** - Users get notified of order updates
- 📈 **Analytics** - Track users, orders, and points

## 📋 Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- HTTPS-enabled hosting (required for Telegram webhooks)
- cURL extension enabled
- PDO extension enabled

## 🚀 Installation

### Step 1: Get Your Bot Token

1. Open Telegram and search for [@BotFather](https://t.me/BotFather)
2. Send `/newbot` command
3. Follow the instructions to create your bot
4. Copy the bot token (looks like: `123456789:ABCdefGHIjklMNOpqrsTUVwxyz`)
5. Copy your bot username (e.g., `@YourBotName`)

### Step 2: Upload Files

Upload all files to your hosting (cPanel, VPS, etc.)

**Recommended directory structure:**
```
public_html/
└── smm-bot/
    ├── bot/
    ├── admin/
    ├── database.sql
    ├── setup.php
    └── README.md
```

### Step 3: Configure Database

1. Open `bot/config.php`
2. Update database credentials:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_database_name');
define('DB_USER', 'your_database_user');
define('DB_PASS', 'your_database_password');
```

### Step 4: Configure Bot

1. In `bot/config.php`, add your bot token:
```php
define('BOT_TOKEN', 'YOUR_BOT_TOKEN_HERE');
define('BOT_USERNAME', 'YourBotUsername');
```

2. Update webhook URL:
```php
define('WEBHOOK_URL', 'https://yourdomain.com/smm-bot/bot/webhook.php');
```

### Step 5: Run Setup

1. Open your browser and navigate to:
   ```
   https://yourdomain.com/smm-bot/setup.php
   ```

2. The setup script will:
   - Create database tables
   - Set up Telegram webhook
   - Create default admin account
   - Verify file permissions

3. Follow the on-screen instructions

### Step 6: Access Admin Panel

1. Navigate to: `https://yourdomain.com/smm-bot/admin/`
2. Login with default credentials:
   - **Username:** `admin`
   - **Password:** `admin123`
3. **⚠️ IMPORTANT:** Change the password immediately!

## 🎮 How to Use

### For Users

1. **Start the bot:**
   - Search for your bot on Telegram
   - Send `/start` command
   - Receive 100 starting points

2. **Refer friends:**
   - Click "Referrals" button
   - Copy your referral link
   - Share with friends
   - Earn 100 points per referral

3. **Place an order:**
   - Select a service (Instagram Views, Telegram Views, etc.)
   - Send the target URL
   - Confirm the order
   - Wait for admin approval

4. **Track orders:**
   - Click "My Orders" to view order history
   - Check status: Pending → Success/Failed

### For Admins

1. **View Dashboard:**
   - See total users, orders, pending orders
   - Monitor points in circulation

2. **Manage Orders:**
   - Go to "Orders" section
   - Filter by status (Pending, Success, Failed)
   - Update order status
   - Users get automatic notifications

3. **Manage Users:**
   - View all users and their points
   - Manually adjust user points
   - View user order history
   - Track referrals

4. **Configure Services:**
   - Edit service pricing
   - Set quantity per order
   - Enable/disable services

## ⚙️ Configuration

### System Constants

Edit in `bot/config.php`:

```php
define('STARTING_POINTS', 100);      // Points for new users
define('REFERRAL_POINTS', 100);      // Points per referral
define('MIN_ORDER_POINTS', 400);     // Minimum order amount
```

### Service Pricing

Configure in Admin Panel → Services:
- **Points Required:** How many points users pay
- **Quantity:** What they receive (e.g., 1000 views)
- **Status:** Active/Inactive

**Example:**
- Points Required: 400
- Quantity: 1000
- Result: Users pay 400 points for 1000 views

## 📁 File Structure

```
smm-bot/
├── bot/
│   ├── config.php          # Configuration
│   ├── database.php        # Database functions
│   ├── handlers.php        # Business logic
│   ├── telegram.php        # Telegram API wrapper
│   ├── webhook.php         # Main webhook handler
│   └── states/             # User session storage
├── admin/
│   ├── index.php           # Login page
│   ├── dashboard.php       # Dashboard
│   ├── orders.php          # Order management
│   ├── users.php           # User management
│   ├── services.php        # Service configuration
│   ├── auth.php            # Authentication
│   ├── includes/
│   │   ├── header.php
│   │   └── footer.php
│   └── css/
│       └── style.css       # Styling
├── database.sql            # Database schema
├── setup.php               # Setup script
└── README.md               # This file
```

## 🔧 Troubleshooting

### Webhook Issues

**Problem:** Webhook not working

**Solutions:**
1. Ensure your URL is HTTPS (not HTTP)
2. Check if webhook.php is accessible
3. Verify bot token is correct
4. Check webhook status:
   ```
   https://api.telegram.org/bot<YOUR_BOT_TOKEN>/getWebhookInfo
   ```

### Database Connection Issues

**Problem:** Database connection failed

**Solutions:**
1. Verify database credentials in `bot/config.php`
2. Ensure database exists
3. Check if MySQL is running
4. Verify user has proper permissions

### Bot Not Responding

**Problem:** Bot doesn't respond to commands

**Solutions:**
1. Check webhook.log file for errors
2. Verify webhook is set correctly
3. Test database connection
4. Check PHP error logs
5. Ensure bot/states/ directory is writable

### Orders Not Creating

**Problem:** Users can't place orders

**Solutions:**
1. Check if user has sufficient points
2. Verify service is active in admin panel
3. Check database for errors
4. Review webhook.log for issues

## 🔐 Security

### Important Security Steps:

1. **Change default admin password** immediately after setup
2. **Delete setup.php** after installation
3. **Set proper file permissions:**
   - Files: 644
   - Directories: 755
   - bot/states/: 755 (writable)

4. **Protect sensitive files:**
   Add to `.htaccess`:
   ```apache
   <Files "config.php">
       Order allow,deny
       Deny from all
   </Files>
   ```

5. **Enable error logging** (disable display_errors in production):
   ```php
   error_reporting(E_ALL);
   ini_set('display_errors', 0);
   ini_set('log_errors', 1);
   ```

## 📊 Database Schema

### Main Tables:
- **users** - User accounts and points
- **orders** - Service orders
- **services** - Available services
- **referrals** - Referral tracking
- **admin_users** - Admin accounts
- **points_log** - Points transaction history

## 🎨 Customization

### Change Admin Panel Colors

Edit `admin/css/style.css`:
```css
:root {
    --primary: #6366f1;      /* Primary color */
    --secondary: #8b5cf6;    /* Secondary color */
    --success: #10b981;      /* Success color */
    --danger: #ef4444;       /* Danger color */
}
```

### Add New Services

1. Go to Admin Panel → Services
2. Or manually insert into database:
```sql
INSERT INTO services (service_name, service_type, points_required, quantity, is_active) 
VALUES ('YouTube Views', 'youtube_views', 500, 1000, 1);
```

### Customize Bot Messages

Edit message templates in `bot/telegram.php`:
- `formatWelcomeMessage()`
- `formatBalanceMessage()`
- `formatServiceMessage()`
- etc.

## 📞 Support

If you encounter any issues:

1. Check the troubleshooting section above
2. Review webhook.log for errors
3. Check PHP error logs
4. Verify all configuration settings

## 📝 License

This project is provided as-is for educational purposes.

## 🙏 Credits

Created for SMM panel automation with Telegram bot integration.

---

**Version:** 1.0  
**Last Updated:** December 2025

**⚠️ Remember to:**
- Change default admin password
- Delete setup.php after installation
- Keep your bot token secure
- Regularly backup your database
