# 🚀 Quick Start Guide

## Telegram SMM Bot - 5 Minute Setup

### Prerequisites
- ✅ Telegram account
- ✅ Web hosting with PHP 7.4+ and MySQL
- ✅ HTTPS enabled domain

---

## Step 1: Create Your Bot (2 minutes)

1. Open Telegram and search: **@BotFather**
2. Send command: `/newbot`
3. Choose a name: `My SMM Bot`
4. Choose a username: `mysmm_bot` (must end with 'bot')
5. **Copy the token** (looks like: `123456789:ABCdefGHI...`)
6. **Copy the username** (e.g., `@mysmm_bot`)

---

## Step 2: Upload Files (1 minute)

Upload all files to your hosting:
```
public_html/
└── smm-bot/          ← Upload here
    ├── bot/
    ├── admin/
    ├── database.sql
    ├── setup.php
    └── README.md
```

---

## Step 3: Configure (1 minute)

Edit `bot/config.php`:

```php
// Line 8-9: Add your bot details
define('BOT_TOKEN', '123456789:ABCdefGHI...');  // Paste your token
define('BOT_USERNAME', 'mysmm_bot');             // Your bot username

// Line 12-15: Database credentials
define('DB_HOST', 'localhost');
define('DB_NAME', 'telegram_smm_bot');           // Your database name
define('DB_USER', 'your_username');              // Your DB username
define('DB_PASS', 'your_password');              // Your DB password

// Line 23: Your domain
define('WEBHOOK_URL', 'https://yourdomain.com/smm-bot/bot/webhook.php');
```

---

## Step 4: Run Setup (1 minute)

1. Open browser: `https://yourdomain.com/smm-bot/setup.php`
2. Wait for green checkmarks ✅
3. Note the admin credentials:
   - Username: `admin`
   - Password: `admin123`

---

## Step 5: Test! (30 seconds)

### Test Bot:
1. Open Telegram
2. Search for your bot: `@mysmm_bot`
3. Send: `/start`
4. You should receive welcome message with 100 points! 🎉

### Test Admin Panel:
1. Open: `https://yourdomain.com/smm-bot/admin/`
2. Login with `admin` / `admin123`
3. You should see the dashboard! 📊

---

## ✅ You're Done!

Your bot is now live and ready to use!

### What Users Can Do:
- ✨ Get 100 starting points
- 👥 Refer friends for 100 points each
- 📱 Order Instagram/Telegram services
- 📊 Track their orders

### What You Can Do (Admin):
- 📦 Manage all orders
- 👥 View all users
- 💰 Adjust user points
- ⚙️ Configure service pricing

---

## 🔒 Important Security Steps

**Do these NOW:**

1. **Change admin password:**
   - Login to admin panel
   - Go to profile settings
   - Change password

2. **Delete setup.php:**
   ```bash
   # Via FTP or file manager, delete:
   smm-bot/setup.php
   ```

3. **Secure config.php:**
   - Already protected by .htaccess ✅

---

## 📱 Share Your Bot

Your bot link:
```
https://t.me/mysmm_bot
```

Share this with users to start getting signups!

---

## 🎯 Default Settings

- **Starting Points:** 100
- **Referral Reward:** 100 points
- **Minimum Order:** 400 points
- **Default Pricing:** 400 points = 1000 views/reactions

Change these in Admin Panel → Services

---

## 🆘 Need Help?

### Bot Not Responding?
1. Check `bot/webhook.log` for errors
2. Verify bot token is correct
3. Ensure webhook URL is HTTPS

### Can't Login to Admin?
1. Username: `admin`
2. Password: `admin123`
3. Check database connection

### Orders Not Working?
1. Verify user has enough points (minimum 400)
2. Check if service is active in admin panel
3. Review webhook.log

---

## 📚 Full Documentation

For detailed documentation, see:
- [README.md](README.md) - Complete guide
- [Walkthrough](walkthrough.md) - Feature overview

---

## 🎉 Enjoy Your Bot!

You now have a fully functional SMM bot running!

**Next Steps:**
- Customize service pricing
- Add more services if needed
- Share your bot link
- Start managing orders!

---

**Questions?** Check the README.md for troubleshooting and advanced configuration.
